/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.trader;

import de.melanx.datatrader.registration.ModStats;
import de.melanx.datatrader.trader.Trade;
import de.melanx.datatrader.trader.TraderContainer;
import de.melanx.datatrader.trader.TraderOffer;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TraderResultSlot
extends Slot {
    private final TraderContainer container;
    private final Player player;
    private int removeCount;
    private final Trade trader;

    public TraderResultSlot(Player player, Trade trader, TraderContainer container, int slot, int xPosition, int yPosition) {
        super((Container)container, slot, xPosition, yPosition);
        this.container = container;
        this.player = player;
        this.trader = trader;
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(@Nonnull ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        this.removeCount = 0;
    }

    public void onTake(@Nonnull Player player, @Nonnull ItemStack stack) {
        ItemStack playerOfferB;
        ItemStack playerOfferA;
        this.checkTakeAchievements(stack);
        TraderOffer activeOffer = this.container.getActiveOffer();
        if (activeOffer != null && (activeOffer.take(playerOfferA = this.container.getItem(0), playerOfferB = this.container.getItem(1)) || activeOffer.take(playerOfferB, playerOfferA))) {
            this.trader.notifyTrade(player, activeOffer);
            player.awardStat(ModStats.tradedWithTrader);
            this.container.setItem(0, playerOfferA);
            this.container.setItem(1, playerOfferB);
            player.giveExperiencePoints(activeOffer.getXp());
        }
    }
}

