/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.trader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.moddingx.libx.util.lazy.LazyValue;

public class TraderOffer {
    public static final Codec<TraderOffer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStackCollection.CODEC.fieldOf("buy").forGetter(TraderOffer::getCostA), (App)ItemStackCollection.CODEC.optionalFieldOf("buyB", (Object)ItemStackCollection.EMPTY).forGetter(TraderOffer::getCostB), (App)ItemStack.CODEC.fieldOf("sell").forGetter(TraderOffer::getResult), (App)Codec.BOOL.optionalFieldOf("rewardExp", (Object)false).forGetter(TraderOffer::rewardsExp), (App)Codec.INT.optionalFieldOf("xp", (Object)0).forGetter(TraderOffer::getXp)).apply((Applicative)instance, TraderOffer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TraderOffer> STREAM_CODEC = StreamCodec.of((buffer, msg) -> {
        ItemStackCollection.STREAM_CODEC.encode(buffer, (Object)msg.getCostA());
        ItemStackCollection.STREAM_CODEC.encode(buffer, (Object)msg.getCostB());
        ItemStack.STREAM_CODEC.encode(buffer, (Object)msg.getResult());
        buffer.writeBoolean(msg.rewardsExp());
        buffer.writeInt(msg.getXp());
    }, buffer -> {
        ItemStackCollection costA = (ItemStackCollection)ItemStackCollection.STREAM_CODEC.decode(buffer);
        ItemStackCollection costB = (ItemStackCollection)ItemStackCollection.STREAM_CODEC.decode(buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buffer);
        boolean rewardExp = buffer.readBoolean();
        int xp = buffer.readInt();
        return new TraderOffer(costA, costB, result, rewardExp, xp);
    });
    private final LazyValue<ItemStackCollection> costA = new LazyValue(() -> costA);
    private final LazyValue<ItemStackCollection> costB = new LazyValue(() -> costB);
    private final ItemStack result;
    private final boolean rewardExp;
    private final int xp;

    public TraderOffer(ItemStackCollection costA, ItemStackCollection costB, ItemStack result, boolean rewardExp, int xp) {
        this.result = result;
        this.rewardExp = rewardExp;
        this.xp = xp;
    }

    public ItemStackCollection getCostA() {
        return (ItemStackCollection)this.costA.get();
    }

    public ItemStackCollection getCostB() {
        return (ItemStackCollection)this.costB.get();
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public boolean rewardsExp() {
        return this.rewardExp;
    }

    public int getXp() {
        return this.xp;
    }

    public ItemStack assemble() {
        return this.result.copy();
    }

    public boolean take(ItemStack playerOfferA, ItemStack playerOfferB) {
        if (!this.satisfiedBy(playerOfferA, playerOfferB)) {
            return false;
        }
        playerOfferA.shrink(this.getCostA().count);
        if (!this.getCostB().isEmpty()) {
            playerOfferB.shrink(this.getCostB().count);
        }
        return true;
    }

    public boolean satisfiedBy(ItemStack playerOfferA, ItemStack playerOfferB) {
        return this.isRequiredItem(playerOfferA, this.getCostA()) && playerOfferA.getCount() >= this.getCostA().count && this.isRequiredItem(playerOfferB, this.getCostB()) && playerOfferB.getCount() >= this.getCostB().count;
    }

    public boolean isRequiredItem(ItemStack offer, ItemStackCollection cost) {
        if (cost.isEmpty() && offer.isEmpty()) {
            return true;
        }
        ItemStack stack = offer.copy();
        if (stack.getItem().isDamageable(stack)) {
            stack.setDamageValue(stack.getDamageValue());
        }
        return cost.has(offer) && (!cost.hasComponents() || !stack.getComponents().isEmpty() && cost.components().test((DataComponentHolder)stack));
    }

    public static class ItemStackCollection {
        public static final Codec<ItemStackCollection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("items").forGetter(ItemStackCollection::getIngredient), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("count").forGetter(ItemStackCollection::getCount), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(ItemStackCollection::components)).apply((Applicative)instance, ItemStackCollection::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackCollection> STREAM_CODEC = StreamCodec.of((buffer, msg) -> {
            Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)msg.ingredient);
            buffer.writeInt(msg.count);
            buffer.writeBoolean(msg.dataComponents != null);
            if (msg.dataComponents != null) {
                DataComponentPredicate.STREAM_CODEC.encode(buffer, (Object)msg.dataComponents);
            }
        }, buffer -> new ItemStackCollection((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), buffer.readInt(), buffer.readBoolean() ? (DataComponentPredicate)DataComponentPredicate.STREAM_CODEC.decode(buffer) : DataComponentPredicate.EMPTY));
        private final Ingredient ingredient;
        private final int count;
        private final DataComponentPredicate dataComponents;
        public static final ItemStackCollection EMPTY = new ItemStackCollection(Ingredient.EMPTY, 0);

        ItemStackCollection(Ingredient ingredient, int count, @Nonnull DataComponentPredicate dataComponents) {
            this.ingredient = ingredient;
            this.count = count;
            this.dataComponents = dataComponents;
        }

        public ItemStackCollection(Ingredient ingredient, int count) {
            this(ingredient, count, DataComponentPredicate.EMPTY);
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public List<ItemStack> getItems() {
            return List.of(this.ingredient.getItems());
        }

        public int getCount() {
            return this.count;
        }

        public boolean isEmpty() {
            return this == EMPTY || this.getItems().isEmpty() || this.count == 0 || this.getItems().stream().allMatch(ItemStack::isEmpty);
        }

        public boolean has(ItemStack stack) {
            return this.ingredient.test(stack) && stack.getCount() >= this.count;
        }

        public boolean hasComponents() {
            return !this.dataComponents.alwaysMatches();
        }

        public DataComponentPredicate components() {
            return this.dataComponents;
        }
    }
}

