/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.trader;

import de.melanx.datatrader.client.ClientSideTrader;
import de.melanx.datatrader.registration.ModMenus;
import de.melanx.datatrader.trader.Trade;
import de.melanx.datatrader.trader.TraderContainer;
import de.melanx.datatrader.trader.TraderOffer;
import de.melanx.datatrader.trader.TraderOffers;
import de.melanx.datatrader.trader.TraderResultSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.moddingx.libx.menu.MenuBase;
import org.moddingx.libx.menu.type.AdvancedMenuType;

public class TraderMenu
extends MenuBase {
    public static final AdvancedMenuType<TraderMenu, Integer> TYPE = AdvancedMenuType.create(TraderMenu::new, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVarInt, FriendlyByteBuf::readVarInt));
    protected static final int PAYMENT1_SLOT = 0;
    protected static final int PAYMENT2_SLOT = 1;
    protected static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int USE_ROW_SLOT_END = 39;
    private static final int SELLSLOT1_X = 136;
    private static final int SELLSLOT2_X = 162;
    private static final int BUYSLOT_X = 220;
    private static final int ROW_Y = 37;
    private final Trade trader;
    private final TraderContainer tradeContainer;

    public TraderMenu(int containerId, Inventory inventory, RegistryFriendlyByteBuf buf) {
        this(containerId, inventory);
    }

    public TraderMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, new ClientSideTrader(inventory.player));
    }

    public TraderMenu(int containerId, Inventory inventory, Trade trader) {
        this((MenuType<TraderMenu>)ModMenus.traderMenu, containerId, inventory, trader);
    }

    public TraderMenu(MenuType<TraderMenu> traderMenuMenuType, int containerId, Inventory inventory, Trade trader) {
        super(traderMenuMenuType, containerId, inventory);
        this.trader = trader;
        this.tradeContainer = new TraderContainer(trader);
        this.addSlot(new Slot((Container)this.tradeContainer, 0, 136, 37));
        this.addSlot(new Slot((Container)this.tradeContainer, 1, 162, 37));
        this.addSlot(new TraderResultSlot(inventory.player, trader, this.tradeContainer, 2, 220, 37));
        this.setOffers(trader.getOffers());
        this.layoutPlayerInventorySlots(108, 84);
    }

    public TraderMenu(@Nullable MenuType<TraderMenu> traderMenuMenuType, int containerId, Level level, Integer integer, Player player, Inventory inventory) {
        this(traderMenuMenuType, containerId, inventory, new ClientSideTrader(player));
    }

    public void slotsChanged(@Nonnull Container container) {
        this.tradeContainer.updateSellItem();
        super.slotsChanged(container);
    }

    public void setOffers(TraderOffers offers) {
        this.trader.overrideOffers(offers);
    }

    public TraderOffers getOffers() {
        return this.trader.getOffers();
    }

    public void setSelectionHint(int index) {
        this.tradeContainer.setSelectionHint(index);
    }

    public void tryMoveItems(int index) {
        ItemStack playerOfferB;
        if (index < 0 || this.getOffers().size() <= index) {
            return;
        }
        ItemStack playerOfferA = this.tradeContainer.getItem(0);
        if (!playerOfferA.isEmpty()) {
            if (!this.moveItemStackTo(playerOfferA, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(0, playerOfferA);
        }
        if (!(playerOfferB = this.tradeContainer.getItem(1)).isEmpty()) {
            if (!this.moveItemStackTo(playerOfferB, 3, 39, true)) {
                return;
            }
            this.tradeContainer.setItem(1, playerOfferB);
        }
        if (!this.tradeContainer.getItem(0).isEmpty() || !this.tradeContainer.getItem(1).isEmpty()) {
            return;
        }
        TraderOffer offer = (TraderOffer)this.getOffers().get(index);
        TraderOffer.ItemStackCollection costA = offer.getCostA();
        TraderOffer.ItemStackCollection costB = offer.getCostB();
        ItemStack mayOfferA = this.firstMatching(offer, costA);
        this.moveFromInventoryToPaymentSlot(0, mayOfferA);
        if (!costB.isEmpty()) {
            ItemStack mayOfferB = this.firstMatching(offer, costB);
            this.moveFromInventoryToPaymentSlot(1, mayOfferB);
        }
    }

    private void moveFromInventoryToPaymentSlot(int paymentSlotIndex, ItemStack paymentSlot) {
        if (!paymentSlot.isEmpty()) {
            for (int i = 3; i < 39; ++i) {
                ItemStack item = ((Slot)this.slots.get(i)).getItem();
                if (item.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)paymentSlot, (ItemStack)item)) continue;
                ItemStack paymentItem = this.tradeContainer.getItem(paymentSlotIndex);
                int paymentItemCount = paymentItem.isEmpty() ? 0 : paymentItem.getCount();
                int transferCount = Math.min(paymentSlot.getMaxStackSize() - paymentItemCount, item.getCount());
                ItemStack itemCopy = item.copy();
                int combinedCount = paymentItemCount + transferCount;
                item.shrink(transferCount);
                itemCopy.setCount(combinedCount);
                this.tradeContainer.setItem(paymentSlotIndex, itemCopy);
                if (combinedCount >= paymentSlot.getMaxStackSize()) break;
            }
        }
    }

    private ItemStack firstMatching(TraderOffer offer, TraderOffer.ItemStackCollection collection) {
        for (int startIndex = 3; startIndex < 39; ++startIndex) {
            ItemStack item = ((Slot)this.slots.get(startIndex)).getItem();
            if (!offer.isRequiredItem(item, collection) || item.getCount() < collection.getCount()) continue;
            return item;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemStack = stack.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(stack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemStack);
                this.playTradeSound();
            } else if (index != 0 && index != 1 ? index >= 3 && index < 39 && !this.moveItemStackTo(stack, 0, 2, false) : !this.moveItemStackTo(stack, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemStack;
    }

    private void playTradeSound() {
        if (!this.trader.isClientSide()) {
            Entity entity = (Entity)this.trader;
            entity.level().playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.VILLAGER_YES, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.tradeContainer.stillValid(player);
    }
}

