/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.trader;

import de.melanx.datatrader.client.ClientSideTrader;
import de.melanx.datatrader.trader.Trade;
import de.melanx.datatrader.trader.TraderOffer;
import de.melanx.datatrader.trader.TraderOffers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TraderContainer
implements Container {
    private final Trade trader;
    private final NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    @Nullable
    private TraderOffer activeOffer;
    private int selectionHint;
    private int futureXp;

    public TraderContainer(Trade trader) {
        this.trader = trader;
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = (ItemStack)this.itemStacks.get(index);
        if (index == 2 && !itemstack.isEmpty()) {
            return ContainerHelper.removeItem(this.itemStacks, (int)index, (int)itemstack.getCount());
        }
        ItemStack itemstack1 = ContainerHelper.removeItem(this.itemStacks, (int)index, (int)count);
        if (!itemstack1.isEmpty() && this.isPaymentSlot(index)) {
            this.updateSellItem();
        }
        return itemstack1;
    }

    private boolean isPaymentSlot(int slot) {
        return slot == 0 || slot == 1;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.itemStacks, (int)index);
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (this.isPaymentSlot(index)) {
            this.updateSellItem();
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        if (this.trader instanceof ClientSideTrader) {
            return true;
        }
        return (double)player.distanceTo((Entity)this.trader) <= player.entityInteractionRange();
    }

    public void setChanged() {
        this.updateSellItem();
    }

    public void updateSellItem() {
        ItemStack itemstack1;
        ItemStack itemstack;
        this.activeOffer = null;
        if (((ItemStack)this.itemStacks.get(0)).isEmpty()) {
            itemstack = (ItemStack)this.itemStacks.get(1);
            itemstack1 = ItemStack.EMPTY;
        } else {
            itemstack = (ItemStack)this.itemStacks.get(0);
            itemstack1 = (ItemStack)this.itemStacks.get(1);
        }
        if (itemstack.isEmpty()) {
            this.setItem(2, ItemStack.EMPTY);
            this.futureXp = 0;
        } else {
            TraderOffers merchantoffers = this.trader.getOffers();
            if (!merchantoffers.isEmpty()) {
                TraderOffer traderOffer = merchantoffers.getTradeFor(itemstack, itemstack1, this.selectionHint);
                if (traderOffer == null) {
                    this.activeOffer = traderOffer;
                    traderOffer = merchantoffers.getTradeFor(itemstack1, itemstack, this.selectionHint);
                }
                if (traderOffer != null) {
                    this.activeOffer = traderOffer;
                    this.setItem(2, traderOffer.assemble());
                    this.futureXp = traderOffer.getXp();
                } else {
                    this.setItem(2, ItemStack.EMPTY);
                    this.futureXp = 0;
                }
            }
        }
    }

    @Nullable
    public TraderOffer getActiveOffer() {
        return this.activeOffer;
    }

    public void setSelectionHint(int currentRecipeIndex) {
        this.selectionHint = currentRecipeIndex;
        this.updateSellItem();
    }

    public void clearContent() {
        this.itemStacks.clear();
    }

    public int getFutureXp() {
        return this.futureXp;
    }
}

