/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.trader;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.datatrader.trader.TraderOffer;
import de.melanx.datatrader.trader.TraderOffers;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.moddingx.libx.datapack.DataLoader;

public class DataTraderOffers
extends SimpleJsonResourceReloadListener {
    public static final Codec<TraderOffers> TRADER_OFFERS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TraderOffer.CODEC.listOf().fieldOf("Recipes").forGetter(offers -> offers.stream().toList())).apply((Applicative)instance, recipes -> {
        TraderOffers offers = new TraderOffers();
        offers.addAll(recipes);
        return offers;
    }));
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, TraderOffers> offers = ImmutableMap.of();

    public DataTraderOffers() {
        super(GSON, "trader_offers");
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profiler) {
        try {
            this.offers = DataLoader.loadJson((ResourceManager)resourceManager, (String)"trader_offers", (id, json) -> (TraderOffers)((Pair)TraderOffers.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.getRegistryLookup()), (Object)json.getAsJsonObject().getAsJsonArray("Offers")).getOrThrow()).getFirst());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TraderOffers getForId(ResourceLocation location) {
        return this.offers.get(location);
    }

    public Set<ResourceLocation> getIds() {
        return this.offers.keySet();
    }
}

