/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.registration;

import de.melanx.datatrader.registration.ModEntities;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.event.EventHooks;

public class ModItems {
    public static final Item traderSpawnEgg = new DeferredSpawnEggItem(() -> ModEntities.dataTrader, 15688241, 12422002, new Item.Properties()){

        public void appendHoverText(ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
            if (((CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("NoAI")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.datatrader.no_ai").withStyle(ChatFormatting.RED));
            }
        }

        @Nonnull
        public Optional<Mob> spawnOffspringFromSpawnEgg(@Nonnull Player player, @Nonnull Mob parent, @Nonnull EntityType<? extends Mob> entityType, @Nonnull ServerLevel level, @Nonnull Vec3 pos, @Nonnull ItemStack stack) {
            if (!this.spawnsEntity(stack, entityType)) {
                return Optional.empty();
            }
            Mob mob = (Mob)entityType.create((Level)level);
            if (mob == null) {
                return Optional.empty();
            }
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(parent.blockPosition()), (MobSpawnType)MobSpawnType.BREEDING, null);
            mob.moveTo(pos.x, pos.y, pos.z, 0.0f, 0.0f);
            level.addFreshEntityWithPassengers((Entity)mob);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                mob.setCustomName(stack.getHoverName());
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return Optional.of(mob);
        }
    };
}

