/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.network.handler;

import de.melanx.datatrader.DataTrader;
import de.melanx.datatrader.trader.TraderMenu;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class SelectTrade
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(DataTrader.getInstance().resource("select_trade"));

    public SelectTrade() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        AbstractContainerMenu abstractMenu = player2.containerMenu;
        if (abstractMenu instanceof TraderMenu) {
            TraderMenu menu = (TraderMenu)abstractMenu;
            if (!menu.stillValid((Player)player2)) {
                DataTrader.getInstance().logger.debug("Player {} interacted with invalid menu {}", (Object)player2, (Object)menu);
                return;
            }
            menu.setSelectionHint(msg.item);
            menu.tryMoveItems(msg.item);
        }
    }

    public record Message(int item) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Message::item, Message::new);

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

