/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.datatrader.registration.ModIngredientTypes;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class TaggedDataComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<TaggedDataComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(TaggedDataComponentIngredient::getTag), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(TaggedDataComponentIngredient::getComponents)).apply((Applicative)instance, TaggedDataComponentIngredient::new));
    private final TagKey<Item> tag;
    private final DataComponentPredicate components;

    private TaggedDataComponentIngredient(TagKey<Item> tag, DataComponentPredicate components) {
        this.tag = tag;
        this.components = components;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public DataComponentPredicate getComponents() {
        return this.components;
    }

    public boolean test(@Nonnull ItemStack stack) {
        return stack.is(this.tag) && this.components.test((DataComponentHolder)stack);
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
            ItemStack stack = new ItemStack(item);
            if (!this.components.alwaysMatches()) {
                stack.applyComponents(this.components.asPatch());
            }
            items.add(stack);
        }
        if (items.isEmpty()) {
            throw new IllegalStateException("No items found for tag " + String.valueOf(this.tag));
        }
        return items.stream();
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return ModIngredientTypes.tagWithComponents;
    }

    public static TaggedDataComponentIngredient of(TagKey<Item> tag) {
        return new TaggedDataComponentIngredient(tag, DataComponentPredicate.EMPTY);
    }

    public static TaggedDataComponentIngredient of(TagKey<Item> tag, DataComponentPredicate components) {
        return new TaggedDataComponentIngredient(tag, components);
    }
}

