/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.melanx.datatrader.DataTrader;
import de.melanx.datatrader.commands.DataTraderCommands;
import de.melanx.datatrader.registration.ModEntities;
import de.melanx.datatrader.trader.Trader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SummonCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"summon").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(((RequiredArgumentBuilder)Commands.argument((String)"offerId", (ArgumentType)ResourceLocationArgument.id()).suggests(DataTraderCommands.OFFER_IDS).executes(context -> SummonCommand.summon((CommandContext<CommandSourceStack>)context, false))).then(Commands.argument((String)"NoAI", (ArgumentType)BoolArgumentType.bool()).executes(context -> SummonCommand.summon((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"NoAI"))))));
    }

    private static int summon(CommandContext<CommandSourceStack> context, boolean noai) {
        Vec3 pos = Vec3Argument.getVec3(context, (String)"pos");
        ResourceLocation offerId = ResourceLocationArgument.getId(context, (String)"offerId");
        if (!DataTrader.getInstance().getOffers().getIds().contains(offerId)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.datatrader.setoffer.wrong_id"));
            return 0;
        }
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Trader trader = (Trader)ModEntities.dataTrader.create((Level)level);
        trader.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(BlockPos.containing((double)pos.x, (double)pos.y, (double)pos.z)), MobSpawnType.BREEDING, null);
        trader.moveTo(pos.x, pos.y, pos.z, 330.0f, 0.0f);
        trader.setNoAi(noai);
        level.addFreshEntity((Entity)trader);
        trader.setOfferId(offerId);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.datatrader.setoffer.success", (Object[])new Object[]{offerId.toString()}), true);
        return 1;
    }
}

