/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.datatrader.DataTrader;
import de.melanx.datatrader.commands.DataTraderCommands;
import de.melanx.datatrader.trader.Trader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SetOfferCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"setOffer").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"offerId", (ArgumentType)ResourceLocationArgument.id()).suggests(DataTraderCommands.OFFER_IDS).executes(SetOfferCommand::setOffer)));
    }

    private static int setOffer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        if (!(entity instanceof Trader)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.datatrader.setoffer.wrong_entity"));
            return 0;
        }
        Trader trader = (Trader)entity;
        ResourceLocation offerId = ResourceLocationArgument.getId(context, (String)"offerId");
        if (!DataTrader.getInstance().getOffers().getIds().contains(offerId)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.datatrader.setoffer.wrong_id"));
            return 0;
        }
        trader.setOfferId(offerId);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.datatrader.setoffer.success", (Object[])new Object[]{offerId.toString()}), true);
        return 1;
    }
}

