/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.datatrader.DataTrader;
import de.melanx.datatrader.ingredients.TaggedDataComponentIngredient;
import de.melanx.datatrader.registration.ModIngredientTypes;
import de.melanx.datatrader.trader.TraderMenu;
import de.melanx.datatrader.trader.TraderOffer;
import de.melanx.datatrader.trader.TraderOffers;
import de.melanx.datatrader.util.ListEntryGetter;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class TraderScreen
extends AbstractContainerScreen<TraderMenu> {
    private static final ResourceLocation VILLAGER_LOCATION = ResourceLocation.parse((String)"textures/gui/container/villager.png");
    private static final ResourceLocation TRADE_ARROW_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/trade_arrow");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller_disabled");
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int SELL_ITEM_1_X = 5;
    private static final int SELL_ITEM_2_X = 35;
    private static final int BUY_ITEM_X = 68;
    private static final int LABEL_Y = 6;
    private static final int NUMBER_OF_OFFER_BUTTONS = 7;
    private static final int TRADE_BUTTON_X = 5;
    private static final int TRADE_BUTTON_HEIGHT = 20;
    private static final int TRADE_BUTTON_WIDTH = 88;
    private static final int SCROLLER_HEIGHT = 27;
    private static final int SCROLLER_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 139;
    private static final int SCROLL_BAR_TOP_POS_Y = 18;
    private static final int SCROLL_BAR_START_X = 94;
    private static final Component TRADES_LABEL = Component.translatable((String)"merchant.trades");
    private int shopItem;
    private final TradeOfferButton[] tradeOfferButtons = new TradeOfferButton[7];
    int scrollOff;
    private boolean isDragging;
    private final Map<TraderOffer, EntryCycler> entryCyclers = new HashMap<TraderOffer, EntryCycler>();

    public TraderScreen(TraderMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 276;
        this.inventoryLabelX = 107;
    }

    private void postButtonClick() {
        ((TraderMenu)this.menu).setSelectionHint(this.shopItem);
        ((TraderMenu)this.menu).tryMoveItems(this.shopItem);
        DataTrader.getNetwork().selectTrade(this.shopItem);
    }

    protected void containerTick() {
        this.entryCyclers.values().forEach(EntryCycler::tick);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int buttonY = y + 18;
        for (int i = 0; i < 7; ++i) {
            this.tradeOfferButtons[i] = (TradeOfferButton)this.addRenderableWidget((GuiEventListener)new TradeOfferButton(x + 5, buttonY, i, button -> {
                if (button instanceof TradeOfferButton) {
                    TradeOfferButton offerButton = (TradeOfferButton)button;
                    this.shopItem = offerButton.getIndex() + this.scrollOff;
                    this.postButtonClick();
                }
            }));
            buttonY += 20;
        }
        this.entryCyclers.clear();
        for (TraderOffer offer : ((TraderMenu)this.menu).getOffers()) {
            this.entryCyclers.put(offer, new EntryCycler(offer.getCostA(), offer.getCostB()));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 49 + this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, Color.DARK_GRAY.getRGB(), false);
        int l = this.font.width((FormattedText)TRADES_LABEL);
        guiGraphics.drawString(this.font, TRADES_LABEL, 5 - l / 2 + 48, 6, Color.DARK_GRAY.getRGB(), false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(VILLAGER_LOCATION, x, y, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
    }

    private void renderScroller(GuiGraphics guiGraphics, int posX, int posY, TraderOffers offers) {
        int steps = offers.size() + 1 - 7;
        if (steps > 1) {
            int leftOver = 139 - (27 + (steps - 1) * 139 / steps);
            int stepHeight = 1 + leftOver / steps + 139 / steps;
            int maxScrollerOff = 113;
            int scrollerYOff = Math.min(maxScrollerOff, this.scrollOff * stepHeight);
            if (this.scrollOff == steps - 1) {
                scrollerYOff = maxScrollerOff;
            }
            guiGraphics.blitSprite(SCROLLER_SPRITE, posX + 94, posY + 18 + scrollerYOff, 0, 6, 27);
        } else {
            guiGraphics.blitSprite(SCROLLER_DISABLED_SPRITE, posX + 94, posY + 18, 0, 6, 27);
        }
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.entryCyclers.isEmpty()) {
            this.init();
            return;
        }
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        TraderOffers offers = ((TraderMenu)this.menu).getOffers();
        if (!offers.isEmpty()) {
            int x = (this.width - this.imageWidth) / 2;
            int y = (this.height - this.imageHeight) / 2;
            int offerY = y + 17;
            int sellItem1X = x + 5 + 5;
            this.renderScroller(guiGraphics, x, y, offers);
            int currentOfferIndex = 0;
            for (TraderOffer offer : offers) {
                if (!this.canScroll(offers.size()) || currentOfferIndex >= this.scrollOff && currentOfferIndex < 7 + this.scrollOff) {
                    EntryCycler entryCycler = this.entryCyclers.get(offer);
                    ItemStack costA = entryCycler.getCostA();
                    ItemStack costB = entryCycler.getCostB();
                    ItemStack result = offer.getResult();
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                    int decorHeight = offerY + 2;
                    guiGraphics.renderFakeItem(costA, sellItem1X, decorHeight);
                    guiGraphics.renderItemDecorations(this.font, costA, sellItem1X, decorHeight);
                    if (!costB.isEmpty()) {
                        guiGraphics.renderFakeItem(costB, x + 5 + 35, decorHeight);
                        guiGraphics.renderItemDecorations(this.font, costB, x + 5 + 35, decorHeight);
                    }
                    this.renderButtonArrows(guiGraphics, x, decorHeight);
                    guiGraphics.renderFakeItem(result, x + 5 + 68, decorHeight);
                    guiGraphics.renderItemDecorations(this.font, result, x + 5 + 68, decorHeight);
                    guiGraphics.pose().popPose();
                    offerY += 20;
                }
                ++currentOfferIndex;
            }
            for (TradeOfferButton button : this.tradeOfferButtons) {
                if (button.isHoveredOrFocused()) {
                    button.renderToolTip(guiGraphics, mouseX, mouseY);
                }
                button.visible = button.index < ((TraderMenu)this.menu).getOffers().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderButtonArrows(GuiGraphics guiGraphics, int posX, int posY) {
        RenderSystem.enableBlend();
        guiGraphics.blitSprite(TRADE_ARROW_SPRITE, posX + 5 + 35 + 20, posY + 3, 0, 10, 9);
    }

    private boolean canScroll(int numOffers) {
        return numOffers > 7;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = ((TraderMenu)this.menu).getOffers().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.scrollOff = Mth.clamp((int)((int)((double)this.scrollOff - scrollY)), (int)0, (int)j);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int i = ((TraderMenu)this.menu).getOffers().size();
        if (this.isDragging) {
            int j = this.topPos + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrollOff = Mth.clamp((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (this.canScroll(((TraderMenu)this.menu).getOffers().size()) && mouseX > (double)(x + 94) && mouseX < (double)(x + 94 + 6) && mouseY > (double)(y + 18) && mouseY <= (double)(y + 18 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private class TradeOfferButton
    extends Button {
        private final int index;

        public TradeOfferButton(int x, int y, int index, Button.OnPress onPress) {
            super(x, y, 88, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.index = index;
            this.visible = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.isHovered && ((TraderMenu)TraderScreen.this.menu).getOffers().size() > this.index + TraderScreen.this.scrollOff) {
                TraderOffer offer = (TraderOffer)((TraderMenu)TraderScreen.this.menu).getOffers().get(this.index + TraderScreen.this.scrollOff);
                EntryCycler entryCycler = TraderScreen.this.entryCyclers.get(offer);
                if (mouseX < this.getX() + 20) {
                    guiGraphics.renderTooltip(TraderScreen.this.font, this.tooltipFromIngredient(offer.getCostA(), entryCycler.getCostA()), entryCycler.getCostA().getTooltipImage(), mouseX, mouseY);
                } else if (mouseX < this.getX() + 50 && mouseX > this.getX() + 30) {
                    if (!entryCycler.getCostB().isEmpty()) {
                        guiGraphics.renderTooltip(TraderScreen.this.font, this.tooltipFromIngredient(offer.getCostB(), entryCycler.getCostB()), entryCycler.getCostB().getTooltipImage(), mouseX, mouseY);
                    }
                } else if (mouseX > this.getX() + 65) {
                    ItemStack result = offer.getResult();
                    guiGraphics.renderTooltip(TraderScreen.this.font, result, mouseX, mouseY);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<Component> tooltipFromIngredient(TraderOffer.ItemStackCollection collection, ItemStack itemStack) {
            TagKey tag;
            List tooltipFromItem = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)itemStack);
            Ingredient ingredient = collection.getIngredient();
            MutableComponent tagIngredient = Component.translatable((String)"tooltip.datatrader.tag_ingredient").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
            ICustomIngredient customIngredient = ingredient.getCustomIngredient();
            if (customIngredient != null && customIngredient.getType() == ModIngredientTypes.tagWithComponents) {
                MutableComponent translatable22 = Component.translatable((String)Tags.getTagTranslationKey(((TaggedDataComponentIngredient)customIngredient).getTag()));
                translatable22.withStyle(itemStack.getRarity().getStyleModifier());
                tooltipFromItem.set(0, translatable22.append(" ").append((Component)tagIngredient));
                return tooltipFromItem;
            }
            if (customIngredient != null) return tooltipFromItem;
            Ingredient.Value translatable22 = ingredient.getValues()[0];
            if (!(translatable22 instanceof Ingredient.TagValue)) return tooltipFromItem;
            Ingredient.TagValue tagValue = (Ingredient.TagValue)translatable22;
            try {
                TagKey tagKey;
                tag = tagKey = tagValue.tag();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            MutableComponent translatable = Component.translatable((String)Tags.getTagTranslationKey((TagKey)tag));
            translatable.withStyle(itemStack.getRarity().getStyleModifier());
            tooltipFromItem.set(0, translatable.append(" ").append((Component)tagIngredient));
            return tooltipFromItem;
        }
    }

    private static class EntryCycler {
        private final ListEntryGetter<ItemStack> costA;
        private ListEntryGetter<ItemStack> costB;
        private final int costACount;
        private int costBCount = 0;

        public EntryCycler(TraderOffer.ItemStackCollection costA, TraderOffer.ItemStackCollection costB) {
            this.costA = new ListEntryGetter<ItemStack>(costA.getItems(), 30);
            this.costACount = costA.getCount();
            if (!costB.isEmpty()) {
                this.costB = new ListEntryGetter<ItemStack>(costB.getItems(), 30);
                this.costBCount = costB.getCount();
            }
        }

        public void tick() {
            this.costA.tick();
            if (this.costB != null) {
                this.costB.tick();
            }
        }

        public ItemStack getCostA() {
            return this.costA.getEntry().copyWithCount(this.costACount);
        }

        public ItemStack getCostB() {
            return this.costB != null ? this.costB.getEntry().copyWithCount(this.costBCount) : ItemStack.EMPTY;
        }
    }
}

