/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.datatrader;

import de.melanx.datatrader.DataTrader;
import de.melanx.datatrader.client.TraderScreen;
import de.melanx.datatrader.registration.ModEntities;
import de.melanx.datatrader.registration.ModItems;
import de.melanx.datatrader.trader.TraderMenu;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="datatrader")
public class EventHandler {
    @SubscribeEvent
    public static void addToTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            for (Item item : List.of(ModItems.traderSpawnEgg)) {
                ItemStack egg = new ItemStack((ItemLike)item);
                ItemStack noAi = egg.copy();
                CustomData.update((DataComponentType)DataComponents.ENTITY_DATA, (ItemStack)noAi, tag -> {
                    tag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(ModEntities.dataTrader).toString());
                    tag.putBoolean("NoAI", true);
                });
                event.accept(egg);
                event.accept(noAi);
            }
        }
    }

    @SubscribeEvent
    public static void resourcesReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)DataTrader.getInstance().getOffers());
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(TraderMenu.TYPE, TraderScreen::new);
    }
}

