/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.curseofcurses.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.curseofcurses.ConfigHandler;
import de.melanx.curseofcurses.CurseOfCurses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CursedData
extends SavedData {
    private static final String NAME = "curse_of_curses";
    private final List<Integer> possibleTimes;
    private final Random random = new Random();
    public static final Codec<CursedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("CurseTimes").forGetter(CursedData::getTimes)).apply((Applicative)instance, CursedData::new));

    public CursedData(List<Integer> times) {
        this.possibleTimes = new ArrayList<Integer>(times);
    }

    public static SavedDataType<CursedData> type() {
        return new SavedDataType(NAME, context -> new CursedData(List.of()), context -> CODEC);
    }

    public static CursedData get(ServerLevel level) {
        DimensionDataStorage storage = level.getServer().overworld().getDataStorage();
        return (CursedData)storage.computeIfAbsent(CursedData.type());
    }

    public List<Integer> getTimes() {
        return this.possibleTimes;
    }

    public void generateTimes() {
        this.possibleTimes.clear();
        for (int i = 0; i < (Integer)ConfigHandler.dangeTimesPerNight.get(); ++i) {
            this.possibleTimes.add(this.random.nextInt((Integer)ConfigHandler.curseTimeEnd.get() - (Integer)ConfigHandler.curseTimeStart.get()) + (Integer)ConfigHandler.curseTimeStart.get());
        }
        CurseOfCurses.LOGGER.debug("Changing dange times to {}", (Object)Arrays.toString(this.possibleTimes.toArray()));
        this.setDirty();
    }
}

