/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.gui;

import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.core.LibResources;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ManaBar {
    private final Screen parent;
    public int x = 153;
    public int y = 15;
    public final int capacity;
    private final int width = 16;
    private final int height = 62;
    public int guiLeft;
    public int guiTop;

    public ManaBar(Screen parent, int capacity) {
        this.parent = parent;
        this.capacity = capacity;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.height;
    }

    public void draw(GuiGraphics guiGraphics, float mana) {
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        guiGraphics.m_280163_(LibResources.MANA_BAR, relX, relY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        float pct = Math.min(mana / (float)this.capacity, 1.0f);
        int relHeight = (int)((float)(this.height - 2) * pct);
        guiGraphics.m_280163_(LibResources.MANA_BAR_CURRENT, ++relX, ++relY + (this.height - 2 - relHeight), 0.0f, 0.0f, this.width - 2, relHeight, this.width - 2, this.height - 2);
    }

    public void renderHoveredToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY, int mana) {
        if (this.isMouseOver(mouseX, mouseY) && LibXClientConfig.numericalMana) {
            MutableComponent text = Component.m_237113_((String)String.format("%s / %s Mana", mana, this.capacity));
            guiGraphics.m_280557_(this.parent.getMinecraft().f_91062_, (Component)text, mouseX, mouseY);
        }
    }
}

