/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tiles;

import de.melanx.botanicalmachinery.blocks.base.WorkingTile;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mythicbotany.infuser.InfuserRecipe;
import mythicbotany.register.ModRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.crafting.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import vazkii.botania.client.fx.WispParticleData;

public class BlockEntityMechanicalManaInfuser
extends WorkingTile<InfuserRecipe> {
    public static final int MAX_MANA_PER_TICK = 50000;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)4).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)ModRecipes.infuser, (ItemStack)stack), new int[]{0, 1, 2}).output(new int[]{3}).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
        this.needsRecipeUpdate();
    }).build();

    public BlockEntityMechanicalManaInfuser(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, ModRecipes.infuser, pos, state, LibXServerConfig.MaxManaCapacity.mechanicalManaInfuser, 0, 3);
    }

    public void tick() {
        double time;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.runRecipeTick();
        } else if (this.f_58857_ != null && LibXClientConfig.AdvancedRendering.all && LibXClientConfig.AdvancedRendering.mechanicalManaInfuser && this.getProgress() > 0 && (time = (double)this.getProgress() / (double)this.getMaxProgress()) < 0.8) {
            double y = (double)this.f_58858_.m_123342_() + 0.375 + 0.3125 * (time *= 1.25);
            double x1 = (double)this.f_58858_.m_123341_() + 0.2 + 0.3 * time;
            double x2 = (double)this.f_58858_.m_123341_() + 0.8 - 0.3 * time;
            double z1 = (double)this.f_58858_.m_123343_() + 0.2 + 0.3 * time;
            double z2 = (double)this.f_58858_.m_123343_() + 0.8 - 0.3 * time;
            WispParticleData data = WispParticleData.wisp((float)0.1f, (float)0.0f, (float)((float)time), (float)((float)(1.0 - time)), (float)1.0f);
            this.f_58857_.m_7106_((ParticleOptions)data, x1, y, z1, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)data, x1, y, z2, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)data, x2, y, z1, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)data, x2, y, z2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> inventory) {
        return slot -> slot == 3;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected int getMaxProgress(InfuserRecipe recipe) {
        return recipe.getManaUsage();
    }

    @Override
    public int getMaxManaPerTick() {
        return 50000 * LibXServerConfig.WorkingDurationMultiplier.mechanicalManaInfuser;
    }
}

