/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityIndustrialAgglomerationFactory;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.moddingx.libx.render.block.RotatedBlockRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class IndustrialAgglomerationFactoryRenderer
extends RotatedBlockRenderer<BlockEntityIndustrialAgglomerationFactory> {
    private final TextureAtlasSprite overlaySprite = Objects.requireNonNull((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix((String)"block/terra_plate_overlay")));

    protected void doRender(@Nonnull BlockEntityIndustrialAgglomerationFactory tile, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.industrialAgglomerationFactory) {
            return;
        }
        double progressLeft = 1.0 - (double)tile.getProgress() / (double)tile.getMaxProgress();
        this.renderStack(tile.getInventory().getStackInSlot(0), poseStack, buffer, partialTick, progressLeft, 0.0f, light);
        this.renderStack(tile.getInventory().getStackInSlot(1), poseStack, buffer, partialTick, progressLeft, 120.0f, light);
        this.renderStack(tile.getInventory().getStackInSlot(2), poseStack, buffer, partialTick, progressLeft, 240.0f, light);
        if (!tile.getInventory().getStackInSlot(3).m_41619_()) {
            float time = (float)ClientTickHandler.ticksInGame + partialTick;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.7, 0.5);
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-time));
            poseStack.m_85837_(0.0, 0.075 * Math.sin((double)time / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(tile.getInventory().getStackInSlot(3), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
            poseStack.m_85849_();
        }
        if (tile.getProgress() > 0) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.3875, 0.29375, 0.3875);
            poseStack.m_85841_(0.225f, 0.225f, 0.225f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85837_(0.0, 0.0, (double)-0.1885f);
            VertexConsumer vertex = buffer.m_6299_(RenderHelper.TERRA_PLATE);
            RenderHelper.renderIconFullBright((PoseStack)poseStack, (VertexConsumer)vertex, (TextureAtlasSprite)this.overlaySprite, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    private void renderStack(ItemStack stack, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, float partialTick, double progressLeft, float angle, int light) {
        if (!stack.m_41619_()) {
            double progressLeftScaled = progressLeft * 0.95;
            float time = (float)ClientTickHandler.ticksInGame + partialTick;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (10.4 - 4.0 * progressLeft) / 16.0, 0.5);
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(angle + time));
            poseStack.m_85837_(progressLeftScaled * 1.125, 0.0, progressLeftScaled * 0.25);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_85837_(0.0, 0.075 * Math.sin((double)(time + angle) / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, (Level)Minecraft.m_91087_().f_91073_, 0);
            poseStack.m_85849_();
        }
    }
}

