/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.containers;

import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityMechanicalDaisy;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.moddingx.libx.menu.BlockEntityMenu;

public class ContainerMenuMechanicalDaisy
extends BlockEntityMenu<BlockEntityMechanicalDaisy> {
    private final BlockEntityMechanicalDaisy.InventoryHandler inventory;

    public ContainerMenuMechanicalDaisy(MenuType<? extends BlockEntityMenu<?>> type, int windowId, Level level, BlockPos pos, Inventory playerContainer, Player player) {
        super(type, windowId, level, pos, playerContainer, player, 8, 8);
        this.inventory = ((BlockEntityMechanicalDaisy)this.blockEntity).getInventory();
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 0, 79, 16));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 1, 100, 16));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 2, 121, 16));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 3, 79, 37));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 4, 121, 37));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 5, 79, 58));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 6, 100, 58));
        this.m_38897_((Slot)new ItemAndFluidSlot(this.inventory, 7, 121, 58));
        this.layoutPlayerInventorySlots(8, 84);
    }

    public void m_150399_(int slot, int dragType, @Nonnull ClickType clickType, @Nonnull Player player) {
        if (clickType == ClickType.PICKUP && slot >= 0 && slot < 8 && !this.m_142621_().m_41619_() && this.m_142621_().m_41613_() == 1) {
            FluidStack maxDrain;
            ItemStack inMouse = this.m_142621_();
            IFluidHandlerItem fluidCap = (IFluidHandlerItem)inMouse.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
            if (inMouse.m_41720_() instanceof BlockItem || fluidCap == null || fluidCap.getTanks() != 1) {
                super.m_150399_(slot, dragType, clickType, player);
                return;
            }
            if (fluidCap.getFluidInTank(0).isEmpty()) {
                if (!this.inventory.getFluidInTank(slot).isEmpty()) {
                    int transferred = fluidCap.fill(this.inventory.getFluidInTank(slot).copy(), IFluidHandler.FluidAction.EXECUTE);
                    this.inventory.getFluidInTank(slot).shrink(transferred);
                    if (this.inventory.getFluidInTank(slot).getAmount() <= 0) {
                        this.inventory.setStackInSlot(slot, FluidStack.EMPTY);
                    }
                }
            } else if (this.inventory.getFluidInTank(slot).isEmpty() && this.inventory.getStackInSlot(slot).m_41619_() && this.inventory.isFluidValid(slot, maxDrain = fluidCap.drain(this.inventory.getTankCapacity(slot), IFluidHandler.FluidAction.SIMULATE))) {
                fluidCap.drain(maxDrain, IFluidHandler.FluidAction.EXECUTE);
                this.inventory.setStackInSlot(slot, maxDrain);
            }
            inMouse = fluidCap.getContainer().m_41777_();
            this.m_38946_();
            this.m_142503_(inMouse);
        }
        super.m_150399_(slot, dragType, clickType, player);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int inventorySize = 5;
            int playerInventoryEnd = 32;
            int playerHotbarEnd = 41;
            if (index < 8) {
                if (!this.m_38903_(stack, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else {
                IFluidHandlerItem fluidCap = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (fluidCap != null && fluidCap.getTanks() == 1) {
                    this.m_38853_(index).m_5852_(this.tryToDepositFluid(fluidCap));
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(stack, 0, 8, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    protected boolean m_38903_(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack) && slot.m_5857_(stack) && (i >= 8 || this.inventory.getFluidInTank(i).isEmpty())) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack) && (i >= 8 || this.inventory.getFluidInTank(i).isEmpty())) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    private ItemStack tryToDepositFluid(IFluidHandlerItem fluidCap) {
        for (int i = 0; i < 8; ++i) {
            FluidStack maxDrain;
            if (!this.inventory.getStackInSlot(i).m_41619_() || !this.inventory.getFluidInTank(i).isEmpty() || !this.inventory.isFluidValid(i, maxDrain = fluidCap.drain(this.inventory.getTankCapacity(i), IFluidHandler.FluidAction.SIMULATE))) continue;
            fluidCap.drain(maxDrain, IFluidHandler.FluidAction.EXECUTE);
            this.inventory.setStackInSlot(i, maxDrain);
        }
        return fluidCap.getContainer();
    }

    public static class ItemAndFluidSlot
    extends SlotItemHandler {
        public final BlockEntityMechanicalDaisy.InventoryHandler inventory;

        public ItemAndFluidSlot(BlockEntityMechanicalDaisy.InventoryHandler inventory, int index, int xPosition, int yPosition) {
            super((IItemHandler)inventory, index, xPosition, yPosition);
            this.inventory = inventory;
        }
    }
}

