/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.base;

import de.melanx.botanicalmachinery.blocks.base.BotanicalTile;
import de.melanx.botanicalmachinery.config.LibXServerConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.crafting.RecipeHelper;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;

public abstract class RecipeTile<T extends Recipe<Container>>
extends BotanicalTile {
    private final RecipeType<T> recipeType;
    private final int firstInputSlot;
    private final int firstOutputSlot;
    protected T recipe;
    private boolean needsRecipeUpdate;

    public RecipeTile(BlockEntityType<?> blockEntityType, RecipeType<T> recipeType, BlockPos pos, BlockState state, int manaCap, int firstInputSlot, int firstOutputSlot) {
        super(blockEntityType, pos, state, manaCap);
        this.recipeType = recipeType;
        this.firstInputSlot = firstInputSlot;
        this.firstOutputSlot = firstOutputSlot;
        this.needsRecipeUpdate = true;
    }

    protected void updateRecipeIfNeeded() {
        this.updateRecipeIfNeeded(() -> {}, (stack, slot) -> {});
    }

    protected void updateRecipeIfNeeded(Runnable doUpdate, BiConsumer<ItemStack, Integer> usedStacks) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.needsRecipeUpdate) {
            this.needsRecipeUpdate = false;
            doUpdate.run();
            this.updateRecipe(usedStacks);
        }
    }

    protected void updateRecipe() {
        this.updateRecipe((stack, slot) -> {});
    }

    protected void updateRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.canMatchRecipes()) {
            this.recipe = null;
            return;
        }
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        List<ItemStack> stacks = IntStream.range(this.firstInputSlot, this.firstOutputSlot).mapToObj(arg_0 -> ((IAdvancedItemHandlerModifiable)inventory).getStackInSlot(arg_0)).toList();
        for (Recipe recipe : this.f_58857_.m_7465_().m_44013_(this.recipeType)) {
            if (!this.matchRecipe(recipe, stacks)) continue;
            ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
            block1: for (Ingredient ingredient : recipe.m_7527_()) {
                for (int stackIdx = 0; stackIdx < stacks.size(); ++stackIdx) {
                    if (!ingredient.test(stacks.get(stackIdx))) continue;
                    ItemStack theStack = stacks.get(stackIdx).m_41777_();
                    theStack.m_41764_(1);
                    consumedStacks.add(theStack.m_41777_());
                    usedStacks.accept(theStack, this.firstInputSlot + stackIdx);
                    continue block1;
                }
            }
            List<ItemStack> resultItems = this.resultItems(recipe, consumedStacks);
            this.recipe = resultItems.isEmpty() || inventory.hasSpaceFor(resultItems, this.firstOutputSlot, inventory.getSlots()) ? recipe : null;
            return;
        }
        this.recipe = null;
    }

    protected void craftRecipe() {
        this.craftRecipe((stack, slot) -> {});
    }

    protected void craftRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.recipe != null) {
            IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
            ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
            block0: for (Ingredient ingredient : this.recipe.m_7527_()) {
                for (int slot = this.firstInputSlot; slot < this.firstOutputSlot; ++slot) {
                    if (!ingredient.test(inventory.getStackInSlot(slot))) continue;
                    ItemStack extracted = inventory.extractItem(slot, 1, false);
                    if (extracted.m_41619_()) continue block0;
                    consumedStacks.add(extracted.m_41777_());
                    usedStacks.accept(extracted, slot);
                    continue block0;
                }
            }
            for (ItemStack result : this.resultItems(this.recipe, consumedStacks)) {
                this.putIntoOutputOrDrop(result.m_41777_());
            }
            this.onCrafted(this.recipe);
            this.recipe = null;
            this.needsRecipeUpdate();
        }
    }

    protected boolean canMatchRecipes() {
        return true;
    }

    protected boolean matchRecipe(T recipe, List<ItemStack> stacks) {
        return RecipeHelper.matches(recipe, stacks, (boolean)false);
    }

    protected void onCrafted(T recipe) {
    }

    protected List<ItemStack> resultItems(T recipe, List<ItemStack> stacks) {
        ItemStack stack = recipe.m_8043_(this.f_58857_.m_9598_());
        if (stack.m_41619_()) {
            return List.of();
        }
        return List.of(stack.m_41777_());
    }

    protected void putIntoOutputOrDrop(ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        ItemStack left = stack.m_41777_();
        for (int slot = this.firstOutputSlot; slot < inventory.getSlots(); ++slot) {
            if (!(left = inventory.insertItem(slot, left, false)).m_41619_()) continue;
            return;
        }
        if (!left.m_41619_()) {
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, left.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    protected void tryPushToAdjacentInventory() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasItemsInOutputSlots()) {
            return;
        }
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        for (Direction dir : Direction.values()) {
            LazyOptional capability;
            IItemHandler itemHandler;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir));
            if (blockEntity == null || !LibXServerConfig.autoExportAllowed.test(ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_())) || (itemHandler = (IItemHandler)(capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())).orElse(null)) == null) continue;
            itemHandlers.add(itemHandler);
        }
        IAdvancedItemHandlerModifiable inventory = this.getInventory().getUnrestricted();
        for (int i = this.firstOutputSlot; i < inventory.getSlots(); ++i) {
            IItemHandler itemHandler;
            ItemStack stack = inventory.getStackInSlot(i);
            Iterator iterator = itemHandlers.iterator();
            while (iterator.hasNext() && !(stack = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = (IItemHandler)iterator.next()), (ItemStack)stack, (boolean)false)).m_41619_()) {
            }
            inventory.setStackInSlot(i, stack);
        }
    }

    protected boolean hasItemsInOutputSlots() {
        IAdvancedItemHandlerModifiable inv = this.getInventory().getUnrestricted();
        int slots = inv.getSlots();
        for (int i = this.firstOutputSlot; i < slots; ++i) {
            if (inv.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void needsRecipeUpdate() {
        this.needsRecipeUpdate = true;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.needsRecipeUpdate = true;
    }
}

